import hilog from '@ohos.hilog';

let messageCallback: (type: string, status: string, data: string) => void;

export class SDKManager {
  static Login_NAME: string = 'Login_SDK';
  static IAP_INIT : string='IAP_Init';
  static IAP_QUERYPRODUCTS : string='IAP_QueryProducts';
  static IAP_PURCHASE : string='IAP_Purchase';
  static IAP_CONSUMEPURCHASE : string='IAP_ConsumePurchase';
  static IAP_QUERYOWNEDPURCHASE : string='IAP_QueryOwnedPurchases';
  static GAMEPLAYER_INIT:string = 'GamePlayer_Init';
  static GAMEPLAYER_GETLOCALPLAYER:string = 'GamePlayer_GetLocalPlayer';
  static GAMEPLAYER_SAVEPLAYERROLE:string = 'GamePlayer_SavePlayerRole';

  static BindCallback(callback: (type: string, status: string, data: string) => void) {
    if (messageCallback === callback) {
      return;
    }
    messageCallback = callback;
    globalThis.messageCallback = messageCallback;
  }

  static HMSSDKSyncToWorker(type:string,result: string) {
    messageCallback(type, "Success", result);
    if (globalThis.sdkInfo === null || globalThis.sdkInfo == undefined) {
      hilog.info(0x0000, "SDKManager", 'new sdk info map');
      let sdkInfo=new Map();
      globalThis.sdkInfo = sdkInfo;
    }
    globalThis.sdkInfo.set(type,result);
    hilog.info(0x0000, "SDKManager", 'global sdk info value: '+JSON.stringify(globalThis.sdkInfo));
  }

  static Login(callback: (type: string, status: string, data: string) => void) {
    SDKManager.BindCallback(callback);
    // 向主线程发送消息
    globalThis.workerPort.postMessage({
      'type': SDKManager.Login_NAME
    });
  }

  static IAPInit(callback: (type: string, status: string, data: string) => void) {
    SDKManager.BindCallback(callback);
    // 向主线程发送消息
    globalThis.workerPort.postMessage({
      'type': SDKManager.IAP_INIT,
    });
  }

  static IAPQueryProducts(storeType: string, storeIdList: string[], callback: (type: string, status: string, data: string) => void) {
    const param = {
      productIds: storeIdList,
      productType: storeType,
    }
    SDKManager.BindCallback(callback);
    // 向主线程发送消息
    globalThis.workerPort.postMessage({
      'type': SDKManager.IAP_QUERYPRODUCTS,
      'data': JSON.stringify(param),
    });
  }

  static IAPPurchase(storeType: string, storeId: string,payLoad:String, callback: (type: string, status: string, data: string) => void) {
    const param = {
      productId: storeId,
      productType: storeType,
      developerPayload:payLoad,
    }
    SDKManager.BindCallback(callback);
    // 向主线程发送消息
    globalThis.workerPort.postMessage({
      'type': SDKManager.IAP_PURCHASE,
      'data': JSON.stringify(param),
    });
  }

  static IAPConsumePurchase(purchaseToken: string, callback: (type: string, status: string, data: string) => void) {
    const parameter = {
      purchaseToken: purchaseToken,
    }
    SDKManager.BindCallback(callback);
    // 向主线程发送消息
    globalThis.workerPort.postMessage({
      'type': SDKManager.IAP_CONSUMEPURCHASE,
      'data': JSON.stringify(parameter),
    });
  }
  static IAPQueryOwnedPurchases(storeType: string, callback: (type: string, status: string, data: string) => void) {
    const param = {
      productType: storeType,
    }
    SDKManager.BindCallback(callback);
    // 向主线程发送消息
    globalThis.workerPort.postMessage({
      'type': SDKManager.IAP_QUERYOWNEDPURCHASE,
      'data': JSON.stringify(param),
    });
  }

  static GamePlayerInit(callback: (type: string, status: string, data: string) => void) {
    SDKManager.BindCallback(callback);
    // 向主线程发送消息
    globalThis.workerPort.postMessage({
      'type': SDKManager.GAMEPLAYER_INIT
    });
  }
  static GamePlayerGetLocalPlayer(callback: (type: string, status: string, data: string) => void) {
    SDKManager.BindCallback(callback);
    // 向主线程发送消息
    globalThis.workerPort.postMessage({
      'type': SDKManager.GAMEPLAYER_GETLOCALPLAYER
    });
  }
  static GamePlayerSavePlayerRole(playerInfo: string, callback: (type: string, status: string, data: string) => void) {
    SDKManager.BindCallback(callback);
    // 向主线程发送消息
    globalThis.workerPort.postMessage({
      'type': SDKManager.GAMEPLAYER_SAVEPLAYERROLE,
      'data': playerInfo
    });
  }
}