//
//  GamePaymentParameters.h
//  HeroUPlatform
//
//  Created by 魏太山 on 2023/6/6.
//  Copyright © 2023 Hero. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface GamePaymentParameters : NSObject

/**
 *  设置本次充值金额, 如果是游戏内充值, 则不需要传, (单位:元)
 *
 *  @param paymentAmount 本次充值金额
 */
-(void)setPaymentAmount:(NSString *)paymentAmount;

/**
 *   本次购买道具名称, 如果是游戏内充值, 则不需要传
 *
 *  @param paymentItemName 游戏道具名称
 */
-(void)setPaymentItemName:(NSString *)paymentItemName;


//IAP参数
// 商品ID
@property (nonatomic, strong) NSString * gamePropID;
// 透传参数
@property (nonatomic, strong) NSString * gameRole;
// CP订单号
@property (nonatomic, copy  ) NSString * cpOrder;
// 内购回调地址，可由运营配置，运营配置了此参数无效（固定回调可不设置，需要同时满足多个回调地址可使用）
@property (nonatomic, copy  ) NSString * callbackUrl;
// 角色id
@property (nonatomic, copy  ) NSString * roleId;
// 角色名称
@property (nonatomic, copy  ) NSString * roleName;
// 服务器id
@property (nonatomic, copy  ) NSString * serverId;
// 服务器名称
@property (nonatomic, copy  ) NSString * serverName;

@end

NS_ASSUME_NONNULL_END
